<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method registerByParams(array $params)
 * @method validateByParams(array $params)
 */
class GeeTest {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 极验初始化验证
     *
     * @support  string $clientType 客户端类型 [ require false ]
     * @support  string $ip 客户端ip [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function register () {
        return self::getClass()->register([
        ]);
    }

    /**
     * 二次验证
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 [ require false ]
     * @support  string $geeTestValidate validate [ require false ]
     * @support  string $geeTestSecCode 核心校验数据 [ require false ]
     * @support  string $phone 用户手机号 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function validate () {
        return self::getClass()->validate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'GeeTest');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'GeeTest');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}