<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method asyncSendWorkNoticeByParams(array $params)
 * @method sendMessageByParams(array $params)
 * @method msgListByParams(array $params)
 * @method msgDetailByParams(array $params)
 * @method readMsgByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送工作通知
     *
     * @param  array $msgContent 消息内容 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function asyncSendWorkNotice (array $msgContent) {
        return self::getClass()->asyncSendWorkNotice([
            "msgContent" => $msgContent,
        ]);
    }

    /**
     * 发送站内信
     *
     * @param  int $from 发信人ID [ require true ]
     * @param  int $to 收信人ID [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  string $msg 消息 [ require true ]
     * @param  string $type 消息类型 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMessage (int $from, int $to, string $title, string $application, string $msg, string $type = '') {
        return self::getClass()->sendMessage([
            "from" => $from,
            "to" => $to,
            "title" => $title,
            "application" => $application,
            "msg" => $msg,
            "type" => $type,
        ]);
    }

    /**
     * 信息列表
     *
     * @param  int $staffId 收信人ID [ require true ]
     * @param  int $from 发送人 [ require false ]
     * @param  string $application 应用 [ require false ]
     * @param  string $type 信息类型 [ require false ]
     * @param  int $is_read 是否阅读 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function msgList (int $staffId, int $is_read = 2, int $from = 0, string $application = '', string $type = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->msgList([
            "staffId" => $staffId,
            "is_read" => $is_read,
            "from" => $from,
            "application" => $application,
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 消息详情
     *
     * @param  int $msgId 消息ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function msgDetail (int $msgId) {
        return self::getClass()->msgDetail([
            "msgId" => $msgId,
        ]);
    }

    /**
     * 修改为已读
     *
     * @param  int $msgId 消息ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function readMsg (int $msgId) {
        return self::getClass()->readMsg([
            "msgId" => $msgId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}