<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendCallByParams(array $params)
 * @method queryCallDetailByCallIdByParams(array $params)
 * @method cancelCallByParams(array $params)
 * @method receiveMsgByParams(array $params)
 */
class VoiceMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 文本转语音外呼
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 已审核通过的语音验证码模板ID [ require true ]
     * @param  array $data 模板中的变量参数 [ require true ]
     * @param  int $playTimes 播放次数，取值范围为1~3 [ require false ]
     * @param  int $volume 音量。取值范围为0~100，默认为100 [ require false ]
     * @param  int $speed 语速控制，取值范围：-500~500 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCall (string $phone, string $code, array $data, int $playTimes = 2, int $volume = 10, int $speed = 60) {
        return self::getClass()->sendCall([
            "phone" => $phone,
            "code" => $code,
            "data" => $data,
            "playTimes" => $playTimes,
            "volume" => $volume,
            "speed" => $speed,
        ]);
    }

    /**
     * 通过呼叫ID获取呼叫记录
     *
     * @param  string $callId 呼叫唯一ID [ require true ]
     * @param  string $date 时间点 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryCallDetailByCallId (string $callId, string $date) {
        return self::getClass()->queryCallDetailByCallId([
            "callId" => $callId,
            "date" => $date,
        ]);
    }

    /**
     * 取消呼叫
     *
     * @param  string $callId 呼叫唯一ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelCall (string $callId) {
        return self::getClass()->cancelCall([
            "callId" => $callId,
        ]);
    }

    /**
     * receiveMsg
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMsg () {
        return self::getClass()->receiveMsg();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'VoiceMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'VoiceMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}