<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendMassageByParams(array $params)
 */
class AliPayMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送支付宝小程序消息
     *
     * @param  int $userId 支付宝用户id [ require true ]
     * @param  string $fromId fromId [ require false ]
     * @param  string $templateId 支付宝模版id [ require true ]
     * @param  string $page 支付宝模版跳转详情页面 [ require true ]
     * @param  array $data 发送消息data [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMassage (int $userId, string $templateId, string $page, array $data, string $fromId = '') {
        return self::getClass()->sendMassage([
            "userId" => $userId,
            "templateId" => $templateId,
            "page" => $page,
            "data" => $data,
            "fromId" => $fromId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'AliPayMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'AliPayMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}