<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCaptchaInfoByParams(array $params)
 * @method validateCaptchaByParams(array $params)
 * @method validateCaptchaWithAjaxByParams(array $params)
 * @method validateInvisibleCaptchaByParams(array $params)
 * @method validateInvisibleCaptcha2ByParams(array $params)
 * @method invisibleCaptchaUseTencentByParams(array $params)
 * @method invisibleCaptchaUseTencentWithoutPhoneByParams(array $params)
 */
class Captcha {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取验证码信息
     *
     * @param  string $type 验证码类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCaptchaInfo (string $type) {
        return self::getClass()->getCaptchaInfo([
            "type" => $type,
        ]);
    }

    /**
     * 验证普通验证码
     *
     * @param  string $type 验证码类型 [ require true ]
     * @param  string $session_id 请求session id [ require true ]
     * @param  string $token 请求的token [ require true ]
     * @param  string $sig 请求sig [ require true ]
     * @param  string $scene 请求scene [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function validateCaptcha (string $type, string $session_id, string $token, string $sig, string $scene) {
        return self::getClass()->validateCaptcha([
            "type" => $type,
            "session_id" => $session_id,
            "token" => $token,
            "sig" => $sig,
            "scene" => $scene,
        ]);
    }

    /**
     * 无痕验证(ajax请求) 第一次风控
     *
     * @support  string $a 验证参数 [ require true ]
     * @support  string $app_name 应用名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function validateCaptchaWithAjax ($context) {
        return self::getClass()->validateCaptchaWithAjax([
            "context" => $context,
        ]);
    }

    /**
     * [阿里云]无痕验证(jsonp 请求) 第一次风控
     *
     * @support  string $a 验证参数 [ require true ]
     * @support  string $app_name 应用名称 [ require true ]
     * @support  string $callback 注册的回调函数名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function validateInvisibleCaptcha ($context) {
        return self::getClass()->validateInvisibleCaptcha([
            "context" => $context,
        ]);
    }

    /**
     * [阿里云]无痕验证 二次风控验证
     *
     * @param  string $data 验证参数 [ require true ]
     * @param  string $business_value 业务参数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function validateInvisibleCaptcha2 (string $data, string $business_value = '') {
        return self::getClass()->validateInvisibleCaptcha2([
            "data" => $data,
            "business_value" => $business_value,
        ]);
    }

    /**
     * [腾讯]无痕验证
     *
     * @support  string $captchaId 无痕验证应用ID [ require false ]
     * @support  string $phone 手机号码 [ require true ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invisibleCaptchaUseTencent ($context) {
        return self::getClass()->invisibleCaptchaUseTencent([
            "context" => $context,
        ]);
    }

    /**
     * [腾讯]无痕验证不用手机号
     *
     * @support  string $captchaId 无痕验证应用ID [ require false ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function invisibleCaptchaUseTencentWithoutPhone ($context) {
        return self::getClass()->invisibleCaptchaUseTencentWithoutPhone([
            "context" => $context,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Captcha');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Captcha');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}