<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSmsCodeByParams(array $params)
 * @method getSmsCodeWithoutCaptionByParams(array $params)
 * @method getSmsCodeWithCodeWithoutCaptionByParams(array $params)
 * @method getSmsCodeWithInvisibleByParams(array $params)
 * @method getSmsCodeByTokenByParams(array $params)
 * @method checkSmsCodeByParams(array $params)
 * @method captchaByParams(array $params)
 * @method sendNotifySmsByParams(array $params)
 */
class Sms {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取短信验证码
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $code 校验码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCode (string $type, string $phone, string $code, string $captcha) {
        return self::getClass()->getSmsCode([
            "type" => $type,
            "phone" => $phone,
            "code" => $code,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 获取短信验证码无需通过验证 （仅后台使用）
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithoutCaption (string $type, string $phone) {
        return self::getClass()->getSmsCodeWithoutCaption([
            "type" => $type,
            "phone" => $phone,
        ]);
    }

    /**
     * 获取指定短信验证码无需通过验证 （仅后台使用）
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithCodeWithoutCaption (string $type, string $phone, string $code) {
        return self::getClass()->getSmsCodeWithCodeWithoutCaption([
            "type" => $type,
            "phone" => $phone,
            "code" => $code,
        ]);
    }

    /**
     * 通过无痕验证后发送短信验证码
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithInvisible (string $type, string $phone, string $token) {
        return self::getClass()->getSmsCodeWithInvisible([
            "type" => $type,
            "phone" => $phone,
            "token" => $token,
        ]);
    }

    /**
     * 验证token并发送短信验证码
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $tokenType TokenType [ require true ]
     * @param  string $token Token验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeByToken (string $type, string $phone, string $tokenType, string $token) {
        return self::getClass()->getSmsCodeByToken([
            "type" => $type,
            "phone" => $phone,
            "tokenType" => $tokenType,
            "token" => $token,
        ]);
    }

    /**
     * 检查验证码是否正确
     *
     * @param  string $phone 电话号码 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSmsCode (string $phone, string $code) {
        return self::getClass()->checkSmsCode([
            "phone" => $phone,
            "code" => $code,
        ]);
    }

    /**
     * 获取验证码
     *
     * @param  string $mode 显示类型 [ require false ]
     * @param  string $type 校验类型 [ require true ]
     * @param  string $code 校验码 [ require true ]
     * @param  string $extend 拓展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function captcha ($context, string $type, string $code, string $extend = '', string $mode = 'base64') {
        return self::getClass()->captcha([
            "context" => $context,
            "type" => $type,
            "code" => $code,
            "extend" => $extend,
            "mode" => $mode,
        ]);
    }

    /**
     * 发送通知短信
     *
     * @param  string $type 发送类型 [ require true ]
     * @param  string $phone 发送手机号码 [ require true ]
     * @param  string $template 发送模板 [ require true ]
     * @param  array $data 信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNotifySms (string $type, string $phone, string $template, array $data) {
        return self::getClass()->sendNotifySms([
            "type" => $type,
            "phone" => $phone,
            "template" => $template,
            "data" => $data,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Sms');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Sms');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}