<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendWorkNoticeByParams(array $params)
 * @method getDepartmentUserIdsByParams(array $params)
 * @method createDingTalkDepByParams(array $params)
 * @method updateDingTalkDepByParams(array $params)
 * @method getDingTalkDepDetailByParams(array $params)
 * @method delDingTalkDepByParams(array $params)
 * @method getDeptByDingTalkDepIdByParams(array $params)
 * @method createDingTalkStaffByParams(array $params)
 * @method updateDingTalkStaffByParams(array $params)
 * @method deleteDingTalkStaffByParams(array $params)
 * @method getDingTalkStaffByDingIdByParams(array $params)
 * @method createProcessByParams(array $params)
 * @method terminateProcessByParams(array $params)
 * @method getProcessInstanceIdsByParams(array $params)
 * @method receiveProcessCallbackByParams(array $params)
 * @method getH5SignByParams(array $params)
 * @method registerDingCallbackByParams(array $params)
 * @method queryDingCallbackListByParams(array $params)
 * @method getProcessInstanceDetailByParams(array $params)
 * @method queryDeptManagerByStaffByParams(array $params)
 * @method getUserByCodeByParams(array $params)
 * @method getStaffScheduleByUserIdsByParams(array $params)
 */
class Ding {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送工作通知
     *
     * @param  string $agentId 应用ID [ require true ]
     * @param  array $msg_package 消息内容 [ require true ]
     * @param  bool $to_all_user 发送所有伙伴 [ require true ]
     * @param  array $department_ids 部门 dingding id [ require true ]
     * @param  array $staff_ding_ids 伙伴 dingding uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWorkNotice (array $msg_package, array $staff_ding_ids = [], array $department_ids = [], string $agentId = '', bool $to_all_user = false) {
        return self::getClass()->sendWorkNotice([
            "msg_package" => $msg_package,
            "staff_ding_ids" => $staff_ding_ids,
            "department_ids" => $department_ids,
            "agentId" => $agentId,
            "to_all_user" => $to_all_user,
        ]);
    }

    /**
     * 获取部门用户ding_user_ids
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartmentUserIds (string $dingTalkDepId) {
        return self::getClass()->getDepartmentUserIds([
            "dingTalkDepId" => $dingTalkDepId,
        ]);
    }

    /**
     * 创建部门
     *
     * @param  string $name 部门名称 [ require true ]
     * @param  string $parentId 父级部门id [ require true ]
     * @param  bool $createDeptGroup 是否创建一个关联此部门的企业群 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDingTalkDep (string $name, string $parentId, bool $createDeptGroup) {
        return self::getClass()->createDingTalkDep([
            "name" => $name,
            "parentId" => $parentId,
            "createDeptGroup" => $createDeptGroup,
        ]);
    }

    /**
     * 修改钉钉部门
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @param  string $name 部门名称 [ require true ]
     * @param  string $parentId 父级部门id [ require true ]
     * @support  array $dingManaegerIds 钉钉部门管理员 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDingTalkDep (string $dingTalkDepId, string $name = '', string $parentId = '') {
        return self::getClass()->updateDingTalkDep([
            "dingTalkDepId" => $dingTalkDepId,
            "name" => $name,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 获取钉钉部门信息
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDingTalkDepDetail (string $dingTalkDepId) {
        return self::getClass()->getDingTalkDepDetail([
            "dingTalkDepId" => $dingTalkDepId,
        ]);
    }

    /**
     * 删除钉钉部门
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDingTalkDep (string $dingTalkDepId) {
        return self::getClass()->delDingTalkDep([
            "dingTalkDepId" => $dingTalkDepId,
        ]);
    }

    /**
     * 获取钉钉部门信息
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDeptByDingTalkDepId (string $dingTalkDepId) {
        return self::getClass()->getDeptByDingTalkDepId([
            "dingTalkDepId" => $dingTalkDepId,
        ]);
    }

    /**
     * 创建钉钉伙伴
     *
     * @param  array $staffInfo 伙伴信息 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function createDingTalkStaff (array $staffInfo) {
        return self::getClass()->createDingTalkStaff([
            "staffInfo" => $staffInfo,
        ]);
    }

    /**
     * 更新钉钉伙伴信息
     *
     * @param  string $dingTalkStaffId 钉钉伙伴id [ require true ]
     * @param  array $staffInfo 伙伴信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDingTalkStaff (string $dingTalkStaffId, array $staffInfo) {
        return self::getClass()->updateDingTalkStaff([
            "dingTalkStaffId" => $dingTalkStaffId,
            "staffInfo" => $staffInfo,
        ]);
    }

    /**
     * 删除钉钉伙伴信息
     *
     * @param  string $dingTalkStaffId 钉钉伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDingTalkStaff (string $dingTalkStaffId) {
        return self::getClass()->deleteDingTalkStaff([
            "dingTalkStaffId" => $dingTalkStaffId,
        ]);
    }

    /**
     * 根据钉钉伙伴id获取钉钉详情
     *
     * @param  string $dingTalkStaffId 钉钉伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDingTalkStaffByDingId (string $dingTalkStaffId) {
        return self::getClass()->getDingTalkStaffByDingId([
            "dingTalkStaffId" => $dingTalkStaffId,
        ]);
    }

    /**
     * 创建审批
     *
     * @param  array $data 审批数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createProcess (array $data) {
        return self::getClass()->createProcess([
            "data" => $data,
        ]);
    }

    /**
     * 终止审批
     *
     * @support  string $instanceId 审批实例ID [ require true ]
     * @support  bool $isSystem 是否通过系统操作 
     * @support  string $remark 终止说明 
     * @support  string $operatorUserId 操作人的userid 
     * @throws  \Exception
     * @return  mixed
     */
    public static function terminateProcess () {
        return self::getClass()->terminateProcess();
    }

    /**
     * 审批实例ids列表
     *
     * @param  string $processCode 审批表单id [ require true ]
     * @param  string $startTimestamp 开始时间戳 13位 [ require true ]
     * @param  string $endTimestamp 结束时间戳 13位 [ require true ]
     * @param  array $userIdList 钉钉user id组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessInstanceIds (string $processCode, string $startTimestamp, string $endTimestamp, array $userIdList = []) {
        return self::getClass()->getProcessInstanceIds([
            "processCode" => $processCode,
            "startTimestamp" => $startTimestamp,
            "endTimestamp" => $endTimestamp,
            "userIdList" => $userIdList,
        ]);
    }

    /**
     * 审批回调
     *
     * @throws  \Exception
     * @return  array
     */
    public static function receiveProcessCallback () {
        return self::getClass()->receiveProcessCallback();
    }

    /**
     * 获取h5 调用api 需要的鉴权值
     *
     * @param  string $url 当前url [ require true ]
     * @param  string $appkey 当前appkey [ require true ]
     * @param  string $appsecret 当前appsecret [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getH5Sign (string $url, string $appkey = NULL, string $appsecret = NULL) {
        return self::getClass()->getH5Sign([
            "url" => $url,
            "appkey" => $appkey,
            "appsecret" => $appsecret,
        ]);
    }

    /**
     * 获取注册钉钉回调请求数据
     *
     * @param  string $callback_name 回调业务名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function registerDingCallback (string $callback_name) {
        return self::getClass()->registerDingCallback([
            "callback_name" => $callback_name,
        ]);
    }

    /**
     * 查询已经注册的钉钉回调地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryDingCallbackList () {
        return self::getClass()->queryDingCallbackList();
    }

    /**
     * 查询已经注册的钉钉回调地址
     *
     * @param  string $processInstanceId 用户钉钉uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProcessInstanceDetail (string $processInstanceId) {
        return self::getClass()->getProcessInstanceDetail([
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 查询某个伙伴的所有上级列表
     *
     * @param  string $dingTalkId 用户钉钉uid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDeptManagerByStaff (string $dingTalkId) {
        return self::getClass()->queryDeptManagerByStaff([
            "dingTalkId" => $dingTalkId,
        ]);
    }

    /**
     * 根据Code获取用户信息
     *
     * @param  string $code 钉钉返回的Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserByCode (string $code) {
        return self::getClass()->getUserByCode([
            "code" => $code,
        ]);
    }

    /**
     * 内部获取钉钉排班表
     *
     * @param  string $appKey 当前appkey [ require true ]
     * @param  string $appSecret 当前appSecret [ require true ]
     * @param  array $userIds 用户钉钉uid数组 [ require true ]
     * @param  string $opUserId 操作人用户ID [ require true ]
     * @param  string $fromTime 开始时间 [ require true ]
     * @param  string $toTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffScheduleByUserIds (string $opUserId, string $appKey, string $appSecret, array $userIds, string $fromTime, string $toTime) {
        return self::getClass()->getStaffScheduleByUserIds([
            "opUserId" => $opUserId,
            "appKey" => $appKey,
            "appSecret" => $appSecret,
            "userIds" => $userIds,
            "fromTime" => $fromTime,
            "toTime" => $toTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Ding');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Ding');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}