<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendWorkNoticeByParams(array $params)
 * @method createDingTalkDepByParams(array $params)
 * @method updateDingTalkDepByParams(array $params)
 * @method delDingTalkDepByParams(array $params)
 * @method createProcessByParams(array $params)
 * @method receiveProcessCallbackByParams(array $params)
 * @method getH5SignByParams(array $params)
 * @method registerDingCallbackByParams(array $params)
 * @method queryDingCallbackListByParams(array $params)
 * @method queryDeptManagerByStaffByParams(array $params)
 * @method getUserByCodeByParams(array $params)
 */
class Ding {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送工作通知
     *
     * @param  array $msg_package 消息内容 [ require true ]
     * @param  array $department_ids 部门 dingding id [ require true ]
     * @param  array $staff_ding_ids 伙伴 dingding uid [ require true ]
     * @param  string $agentId 应用ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendWorkNotice (array $msg_package, array $staff_ding_ids = [], array $department_ids = [], string $agentId = '') {
        return self::getClass()->sendWorkNotice([
            "msg_package" => $msg_package,
            "staff_ding_ids" => $staff_ding_ids,
            "department_ids" => $department_ids,
            "agentId" => $agentId,
        ]);
    }

    /**
     * 创建部门
     *
     * @param  string $name 部门名称 [ require true ]
     * @param  string $parentId 父级部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDingTalkDep (string $name, string $parentId) {
        return self::getClass()->createDingTalkDep([
            "name" => $name,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 修改钉钉部门
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @param  string $name 部门名称 [ require true ]
     * @param  string $parentId 父级部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateDingTalkDep (string $dingTalkDepId, string $name = '', string $parentId = '') {
        return self::getClass()->updateDingTalkDep([
            "dingTalkDepId" => $dingTalkDepId,
            "name" => $name,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 删除钉钉部门
     *
     * @param  string $dingTalkDepId 钉钉部门id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delDingTalkDep (string $dingTalkDepId) {
        return self::getClass()->delDingTalkDep([
            "dingTalkDepId" => $dingTalkDepId,
        ]);
    }

    /**
     * 创建审批
     *
     * @param  array $data 审批数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createProcess (array $data) {
        return self::getClass()->createProcess([
            "data" => $data,
        ]);
    }

    /**
     * 审批回调
     *
     * @throws  \Exception
     * @return  array
     */
    public static function receiveProcessCallback () {
        return self::getClass()->receiveProcessCallback();
    }

    /**
     * 获取h5 调用api 需要的鉴权值
     *
     * @param  string $url 当前url [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getH5Sign (string $url) {
        return self::getClass()->getH5Sign([
            "url" => $url,
        ]);
    }

    /**
     * 注册钉钉回调
     *
     * @param  string $callback_name 回调业务名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function registerDingCallback (string $callback_name) {
        return self::getClass()->registerDingCallback([
            "callback_name" => $callback_name,
        ]);
    }

    /**
     * 查询已经注册的钉钉回调地址
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryDingCallbackList () {
        return self::getClass()->queryDingCallbackList();
    }

    /**
     * 查询某个伙伴的所有上级列表
     *
     * @param  string $dingTalkId 用户钉钉uid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDeptManagerByStaff (string $dingTalkId) {
        return self::getClass()->queryDeptManagerByStaff([
            "dingTalkId" => $dingTalkId,
        ]);
    }

    /**
     * 根据Code获取用户信息
     *
     * @param  string $code 钉钉返回的Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserByCode (string $code) {
        return self::getClass()->getUserByCode([
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Ding');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Ding');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}