<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendMessageByParams(array $params)
 * @method msgListByParams(array $params)
 * @method msgDetailByParams(array $params)
 * @method readMsgByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送站内信
     *
     * @param  int $from 发信人ID [ require true ]
     * @param  int $to 收信人ID [ require true ]
     * @param  string $title 标题 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  string $msg 消息 [ require true ]
     * @param  string $type 消息类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMessage (int $from, int $to, string $title, string $application, string $msg, string $type = '') {
        return self::getClass()->sendMessage([
            "from" => $from,
            "to" => $to,
            "title" => $title,
            "application" => $application,
            "msg" => $msg,
            "type" => $type,
        ]);
    }

    /**
     * 信息列表
     *
     * @param  int $staffId 收信人ID [ require true ]
     * @param  int $from 发送人 [ require true ]
     * @param  string $application 应用 [ require true ]
     * @param  string $type 信息类型 [ require true ]
     * @param  int $is_read 是否阅读 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function msgList (int $staffId, int $is_read = 2, int $from = 0, string $application = '', string $type = '', int $page = 1, int $pageSize = 15) {
        return self::getClass()->msgList([
            "staffId" => $staffId,
            "is_read" => $is_read,
            "from" => $from,
            "application" => $application,
            "type" => $type,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 消息详情
     *
     * @param  int $msgId 消息ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function msgDetail (int $msgId) {
        return self::getClass()->msgDetail([
            "msgId" => $msgId,
        ]);
    }

    /**
     * 修改为已读
     *
     * @param  int $msgId 消息ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function readMsg (int $msgId) {
        return self::getClass()->readMsg([
            "msgId" => $msgId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}