<?php
namespace Mainto\Bridge\Invokes\Notify;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getVerificationCodeByParams(array $params)
 * @method checkVerificationCodeByParams(array $params)
 */
class Mail {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送邮箱验证码
     *
     * @param  string $email 邮箱 [ require true ]
     * @param  string $title 邮件名称 [ require true ]
     * @param  string $fromName 发件人名称 [ require true ]
     * @param  string $fromMailer 发件人邮箱配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getVerificationCode (string $email, string $title, string $fromName, string $fromMailer = NULL) {
        return self::getClass()->getVerificationCode([
            "email" => $email,
            "title" => $title,
            "fromName" => $fromName,
            "fromMailer" => $fromMailer,
        ]);
    }

    /**
     * 检查验证码是否正确
     *
     * @param  string $email 邮箱 [ require true ]
     * @param  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkVerificationCode (string $email, string $code) {
        return self::getClass()->checkVerificationCode([
            "email" => $email,
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Notify', 'Mail');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Notify', 'Mail');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}