<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addShopCartByParams(array $params)
 * @method getUserShopCartByParams(array $params)
 * @method deleteShopCartByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加购物车
     *
     * @support  int $cityId 城市id [ require true ]
     * @support  array $categories 城市id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addShopCart () {
        return self::getClass()->addShopCart([
        ]);
    }

    /**
     * 获取购物车信息
     *
     * @support  int $cityId 城市id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserShopCart () {
        return self::getClass()->getUserShopCart([
        ]);
    }

    /**
     * 删除购物车
     *
     * @support  array $cartIds 记录ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShopCart () {
        return self::getClass()->deleteShopCart([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}