<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 */
class Feedback {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 意见反馈
     *
     * @support  string $note 建议 [ require false ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $allStar 总评分 [ require false ]
     * @param  bool $isShare 是否参与分享 [ require false ]
     * @support  int $reception 前台打分 [ require false ]
     * @support  int $watchmaker 看片师打分 [ require false ]
     * @support  int $photographer 摄影师打分 [ require false ]
     * @support  int $makeupArtist 化妆师打分 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $orderId, int $allStar = 0, bool $isShare = 0) {
        return self::getClass()->create([
            "orderId" => $orderId,
            "allStar" => $allStar,
            "isShare" => $isShare,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\Feedback');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\Feedback');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}