<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByStoreByParams(array $params)
 * @method getStaffsByConditionByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getManagersByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据管理店铺获取员工信息
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 获取记录条数 [ require false ]
     * @support  string $status 离职: step_down; 在职:on_the_job;全部: anybody [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStaffListByStore () {
        return self::getClass()->getStaffListByStore([
        ]);
    }

    /**
     * 获取伙伴列表-分页
     *
     * @support  string $name 员工姓名 [ require false ]
     * @support  string $status 离职: step_down; 在职:on_the_job;全部: anybody [ require false ]
     * @support  int $staffNum 工号 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 获取记录条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffsByCondition () {
        return self::getClass()->getStaffsByCondition([
        ]);
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取管理员列表
     *
     * @support  string $name 员工姓名 [ require false ]
     * @support  int $staffNum 员工工号 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getManagers (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getManagers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}