<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method successReserveByParams(array $params)
 * @method createStaffNoteByParams(array $params)
 */
class CustomerReserve {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客资列表
     *
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  string $phone 手机号 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $created_at_start 创建时间 [ require false ]
     * @support  string $created_at_end 创建时间 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 标记处理客资
     *
     * @support  string $_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function successReserve () {
        return self::getClass()->successReserve([
        ]);
    }

    /**
     * 添加员工备注
     *
     * @support  string $_id id [ require true ]
     * @support  string $staff_note id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createStaffNote () {
        return self::getClass()->createStaffNote([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\CustomerReserve');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\CustomerReserve');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}