<?php
namespace Mainto\Bridge\Invokes\MantoProject\Reservation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRowListByParams(array $params)
 * @method getListByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表时间
     *
     * @support  int $storeId 门店Id require false
     * @support  string $dateStart 起止日期 require false
     * @support  string $dateEnd 结束日期 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRowList () {
        return self::getClass()->getRowList();
    }

    /**
     * 客户端排单表
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  string $date_start 开始日期 [ require true ]
     * @support  string $date_end 结束日期 [ require true ]
     * @support  array $product_group 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Reservation\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Reservation\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}