<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getListByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表时间
     *
     * @param  int $storeId 门店Id [ require true ]
     * @param  string $dateStart 起止日期 [ require true ]
     * @param  string $dateEnd 结束日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $storeId, string $dateStart, string $dateEnd) {
        return self::getClass()->list([
            "storeId" => $storeId,
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * 客户端排单表
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  array $product_group 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (int $store_id, string $date_start, string $date_end, array $product_group) {
        return self::getClass()->getList([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
            "product_group" => $product_group,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}