<?php
namespace Mainto\Bridge\Invokes\MantoProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByStoreByParams(array|StaffManage\GetStaffListByStore\StaffListQueryDto $params)
 */
class StaffManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据管理店铺获取员工信息
     *
     * @var  StaffManage\GetStaffListByStore\StaffListQueryDto $staffListQueryDto $staffListQueryDto
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByStore (StaffManage\GetStaffListByStore\StaffListQueryDto $staffListQueryDto) {
        return self::getClass()->getStaffListByStore($staffListQueryDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Manage\StaffManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Manage\StaffManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}