<?php
namespace Mainto\Bridge\Invokes\MantoProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|CustomerManage\ListSafeNamespace\QueryCustomerCmd $params)
 * @method successReserveByParams(array $params)
 * @method createStaffNoteByParams(array $params)
 */
class CustomerManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 客资列表
     *
     * @var  CustomerManage\ListSafeNamespace\QueryCustomerCmd $queryCustomerCmd $queryCustomerCmd
     * @throws  \Exception
     * @return  array
     */
    public static function list (CustomerManage\ListSafeNamespace\QueryCustomerCmd $queryCustomerCmd) {
        return self::getClass()->list($queryCustomerCmd);
    }


    /**
     * 标记处理客资
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function successReserve () {
        return self::getClass()->successReserve();
    }

    /**
     * 添加员工备注
     *
     * @support  string $_id id [ require true ]
     * @support  string $staff_note id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStaffNote () {
        return self::getClass()->createStaffNote();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Manage\CustomerManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Manage\CustomerManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}