<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreProductsByParams(array $params)
 * @method getStoreProductDetailByParams(array $params)
 * @method getStoreCategoriesByParams(array $params)
 * @method getStoreDiscountByParams(array $params)
 * @method getProductPriceByParams(array $params)
 */
class NewProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品
     *
     * @support  array $storeIds 门店ids require false
     * @support  int $prune 是否精简字段，1：精简，0：不精简 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProducts () {
        return self::getClass()->getStoreProducts();
    }

    /**
     * 获取门店产品详情
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $productId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductDetail () {
        return self::getClass()->getStoreProductDetail();
    }

    /**
     * 获取门店类型列表
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  array $categoryIds 类目Ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreCategories () {
        return self::getClass()->getStoreCategories();
    }

    /**
     * 获取门店折扣规则
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreDiscount () {
        return self::getClass()->getStoreDiscount();
    }

    /**
     * 获取门店类型列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPrice () {
        return self::getClass()->getProductPrice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'NewProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'NewProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}