<?php
namespace Mainto\Bridge\Invokes\MantoProject\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|Create\OrderCreateDto $params)
 * @method payByParams(array $params)
 * @method payCallbackByParams(array $params)
 * @method getOrdersByParams(array $params)
 * @method infoByParams(array $params)
 * @method closeByParams(array $params)
 * @method firstPayByParams(array $params)
 * @method secondPayByParams(array $params)
 * @method closePaymentByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单【定金支付】
     *
     * @var  Create\OrderCreateDto $orderCreateDto $orderCreateDto
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (Create\OrderCreateDto $orderCreateDto) {
        return self::getClass()->create($orderCreateDto);
    }


    /**
     * 发起支付
     *
     * @support  float $money 金额 [ require true ]
     * @support  string $openId 用户openId require false
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pay () {
        return self::getClass()->pay();
    }

    /**
     * 支付回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function payCallback () {
        return self::getClass()->payCallback();
    }

    /**
     * 获取订单信息
     *
     * @support  array $status 订单状态 require false
     * @support  int $page 分页 require false
     * @support  int $pageSize 页数 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrders () {
        return self::getClass()->getOrders();
    }

    /**
     * 根据订单号获取订单
     *
     * @support  string $orderNum 订单号 require false
     * @support  int $orderId 订单id require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 取消订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $orderId) {
        return self::getClass()->close([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 支付订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  int $orderDiffId diffid [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $paymentNo paymentNo require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstPay () {
        return self::getClass()->firstPay();
    }

    /**
     * 支付订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  int $orderDiffId diffid [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $paymentNo paymentNo require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondPay () {
        return self::getClass()->secondPay();
    }

    /**
     * 关闭支付单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePayment () {
        return self::getClass()->closePayment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}