<?php
namespace Mainto\Bridge\Invokes\MantoProject\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|OrderWorkload\Create\OrderServantDto $params)
 * @method workloadDetailByParams(array $params)
 * @method getWorkloadByConditionByParams(array|OrderWorkload\GetWorkloadByCondition\WorkLoadDto $params)
 * @method exportByParams(array|OrderWorkload\Export\WorkLoadDto $params)
 */
class OrderWorkload {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入工作量
     *
     * @var  OrderWorkload\Create\OrderServantDto $orderServantDto $orderServantDto
     * @throws  \Exception
     * @return  bool
     */
    public static function create (OrderWorkload\Create\OrderServantDto $orderServantDto) {
        return self::getClass()->create($orderServantDto);
    }


    /**
     * 获取工作量
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function workloadDetail (int $orderId) {
        return self::getClass()->workloadDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询伙伴工作量
     *
     * @var  OrderWorkload\GetWorkloadByCondition\WorkLoadDto $workLoadDto $workLoadDto
     * @throws  \Exception
     * @return  array
     */
    public static function getWorkloadByCondition (OrderWorkload\GetWorkloadByCondition\WorkLoadDto $workLoadDto) {
        return self::getClass()->getWorkloadByCondition($workLoadDto);
    }


    /**
     * 伙伴工作量导出
     *
     * @var  OrderWorkload\Export\WorkLoadDto $workLoadDto $workLoadDto
     * @throws  \Exception
     * @return  array
     */
    public static function export (OrderWorkload\Export\WorkLoadDto $workLoadDto) {
        return self::getClass()->export($workLoadDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Manage\OrderWorkload');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Manage\OrderWorkload');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}