<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getWorkloadByOrderIdByParams(array $params)
 * @method getWorkloadByConditionByParams(array $params)
 * @method exportByParams(array $params)
 */
class Workload {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入工作量
     *
     * @param  int $orderId 订单号 [ require true ]
     * @param  array $workData 录入的工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $orderId, array $workData) {
        return self::getClass()->create([
            "orderId" => $orderId,
            "workData" => $workData,
        ]);
    }

    /**
     * 获取工作量
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWorkloadByOrderId (int $orderId) {
        return self::getClass()->getWorkloadByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 查询伙伴工作量
     *
     * @support  string $staffType 伙伴类型 require false
     * @support  int $staffId 伙伴ID [ require true ]
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @support  int $page 页码 require false
     * @support  int $pageSize 每页显示数据 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWorkloadByCondition () {
        return self::getClass()->getWorkloadByCondition();
    }

    /**
     * 伙伴工作量导出
     *
     * @support  string $staffType 伙伴类型 require false
     * @support  int $staffId 伙伴ID [ require true ]
     * @support  string $startTime 开始时间 require false
     * @support  string $endTime 结束时间 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Workload');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Workload');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}