<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method payByParams(array $params)
 * @method payCallbackByParams(array $params)
 * @method getOrdersByParams(array $params)
 * @method infoByParams(array $params)
 * @method closeByParams(array $params)
 * @method firstPayByParams(array $params)
 * @method secondPayByParams(array $params)
 * @method closePaymentByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单【定金支付】
     *
     * @param  float $money 实际支付金额 [Original type unsignedDouble] [ require true ]
     * @support  string $payMode 支付模式 [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @support  int $couponId 优惠券ID 
     * @param  string $reserveTime 预约时间 [ require true ]
     * @support  array $detail 产品组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $reserveTime, int $storeId, float $money) {
        return self::getClass()->create([
            "reserveTime" => $reserveTime,
            "storeId" => $storeId,
            "money" => $money,
        ]);
    }

    /**
     * 发起支付
     *
     * @support  float $money 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $openId 用户openId 
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pay () {
        return self::getClass()->pay();
    }

    /**
     * 支付回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function payCallback () {
        return self::getClass()->payCallback();
    }

    /**
     * 获取订单信息
     *
     * @param  array $status 订单状态 [ require true ]
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $pageSize 页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrders (array $status, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOrders([
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据订单号获取订单
     *
     * @support  string $orderNum 订单号 
     * @support  int $orderId 订单id 
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 取消订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $orderId) {
        return self::getClass()->close([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 支付订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  int $orderDiffId diffid [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $paymentNo paymentNo 
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstPay () {
        return self::getClass()->firstPay();
    }

    /**
     * 支付订单
     *
     * @support  int $id 订单id [ require true ]
     * @support  int $orderDiffId diffid [ require true ]
     * @support  string $payType 支付方式 [ require true ]
     * @support  string $paymentNo paymentNo 
     * @throws  \Exception
     * @return  mixed
     */
    public static function secondPay () {
        return self::getClass()->secondPay();
    }

    /**
     * 关闭支付单
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePayment () {
        return self::getClass()->closePayment();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}