<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method payByParams(array $params)
 * @method finalPayByParams(array $params)
 * @method getOrderDataByParams(array $params)
 * @method infoByParams(array $params)
 * @method startShootingByParams(array $params)
 * @method getClassificationStatusByParams(array $params)
 * @method switchStoreByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method closeOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $sex 用户性别 [ require true ]
     * @support  string $note 订单备注 
     * @support  float $money 付款金额 [Original type unsignedDouble] [ require true ]
     * @support  string $phone 用户手机号 [ require true ]
     * @support  string $birthday 生日 [ require true ]
     * @support  string $payMode 支付模式 [ require true ]
     * @support  string $email 用户邮箱 [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  string $discountNote 特殊折扣备注 
     * @support  array $detail 产品组 [ require true ]
     * @support  float $specialDiscount 折扣金额【缦图后台手动录入】 [Original type unsignedDouble] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 支付
     *
     * @param  int $orderId 订单ID [Original type uint] [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  float $money 首付款金额 [Original type double] [ require true ]
     * @param  string $payMode 支付模式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pay (string $payMode, int $orderId, float $money, string $payType) {
        return self::getClass()->pay([
            "payMode" => $payMode,
            "orderId" => $orderId,
            "money" => $money,
            "payType" => $payType,
        ]);
    }

    /**
     * 缦图订单付尾款
     *
     * @param  int $orderId 订单ID [Original type uint] [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  float $money 尾款金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finalPay (int $orderId, string $payType, float $money) {
        return self::getClass()->finalPay([
            "orderId" => $orderId,
            "payType" => $payType,
            "money" => $money,
        ]);
    }

    /**
     * 订单搜索-分页
     *
     * @support  string $phone 手机号 
     * @support  array $status 订单状态 
     * @support  string $orderNum 订单号 
     * @support  string $userName 姓名 
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $pageSize 页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderData (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOrderData([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $orderId) {
        return self::getClass()->info([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 开始拍摄
     *
     * @support  int $orderId 订单id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function startShooting () {
        return self::getClass()->startShooting();
    }

    /**
     * 获取订单状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getClassificationStatus () {
        return self::getClass()->getClassificationStatus();
    }

    /**
     * 切换门店
     *
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function switchStore (int $store_id) {
        return self::getClass()->switchStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $orderId, string $reserveTime, string $note = '') {
        return self::getClass()->changeReserveTime([
            "orderId" => $orderId,
            "reserveTime" => $reserveTime,
            "note" => $note,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $orderId 订单Id [Original type uint] [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (int $orderId, string $reason) {
        return self::getClass()->closeOrder([
            "orderId" => $orderId,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}