<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method closeOrderTimeByParams(array $params)
 * @method getListByParams(array $params)
 * @method getListOriByParams(array $params)
 * @method batchCloseByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表列表
     *
     * @param  string $dateStart 日期起 [ require true ]
     * @param  string $dateEnd 日期止 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $dateStart, string $dateEnd) {
        return self::getClass()->list([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * 关闭时间点
     *
     * @param  string $status 位置的状态 [ require true ]
     * @param  string $orderTime 预约时间 [ require true ]
     * @param  int $index 预约位置索引(预约时间和索引必填一项) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderTime (string $status, string $orderTime, int $index) {
        return self::getClass()->closeOrderTime([
            "status" => $status,
            "orderTime" => $orderTime,
            "index" => $index,
        ]);
    }

    /**
     * 客户端排单表
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  array $product_group 产品数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $store_id, string $date_start, string $date_end, array $product_group = []) {
        return self::getClass()->getList([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
            "product_group" => $product_group,
        ]);
    }

    /**
     * 客户端排单表
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @support  array $product_group 产品数组 
     * @throws  \Exception
     * @return  array
     */
    public static function getListOri (int $store_id, string $date_start, string $date_end) {
        return self::getClass()->getListOri([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
        ]);
    }

    /**
     * 批量关闭时间节点
     *
     * @param  int $each_time_unset 关闭时间节点的位置数 [ require true ]
     * @param  string $date_begin 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  string $time_begin 开始时间 [ require true ]
     * @param  string $time_end 结束时间 [ require true ]
     * @param  bool $all_success 是否不允许部分失败 [ require true ]
     * @support  bool $is_repeat 是否按日重复关闭 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (int $each_time_unset, string $date_begin, string $date_end, string $time_begin, string $time_end, bool $all_success = false) {
        return self::getClass()->batchClose([
            "each_time_unset" => $each_time_unset,
            "date_begin" => $date_begin,
            "date_end" => $date_end,
            "time_begin" => $time_begin,
            "time_end" => $time_end,
            "all_success" => $all_success,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}