<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method delOrderSaleByParams(array $params)
 * @method getDsByStoreByParams(array $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个订单修改(订单完成前)
     *
     * @support  int $orderId 订单ID 
     * @support  int $inputStaffId 主推人 
     * @support  float $needPaidMoney 订单待支付金额 [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  string $type 订单类型 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 设置diff订单完成支付
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $orderDiffId order_diff的id [ require true ]
     * @support  string $diffType 类型:upgrade和order [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  string $paymentNo 支付流水号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid () {
        return self::getClass()->setPaid();
    }

    /**
     * 删除二销订单
     *
     * @support  int $saleId 二销ID [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  string $reason 关闭原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function delOrderSale () {
        return self::getClass()->delOrderSale();
    }

    /**
     * 根据门店查询ds数据
     *
     * @support  int $dsModel 查询ds类型 1:共享 2主推 [ require true ]
     * @support  int $staffId 员工id [ require true ]
     * @support  string $startTime 查询开始时间 [ require true ]
     * @support  string $endTime 查询结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getDsByStore () {
        return self::getClass()->getDsByStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}