<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOrderDataByParams(array $params)
 * @method payByParams(array $params)
 * @method payCallbackByParams(array $params)
 * @method getOrdersByParams(array $params)
 * @method infoByParams(array $params)
 * @method closeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单【定金支付】
     *
     * @param  float $money 实际支付金额 [Original type unsignedDouble] [ require true ]
     * @support  string $payMode 支付模式 [ require true ]
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @support  int $couponId 优惠券ID 
     * @param  string $reserveTime 预约时间 [ require true ]
     * @support  array $productGroup 产品组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrderData (string $reserveTime, int $storeId, float $money) {
        return self::getClass()->addOrderData([
            "reserveTime" => $reserveTime,
            "storeId" => $storeId,
            "money" => $money,
        ]);
    }

    /**
     * 发起支付
     *
     * @param  float $money 金额 [Original type unsignedDouble] [ require true ]
     * @param  string $openId 用户openId [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pay (int $orderId, string $payType, float $money, int $storeId, string $openId = '') {
        return self::getClass()->pay([
            "orderId" => $orderId,
            "payType" => $payType,
            "money" => $money,
            "storeId" => $storeId,
            "openId" => $openId,
        ]);
    }

    /**
     * 支付回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function payCallback () {
        return self::getClass()->payCallback();
    }

    /**
     * 获取订单信息
     *
     * @param  array $status 订单状态 [ require true ]
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $pageSize 页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrders (array $status, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOrders([
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 根据订单号获取订单
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (string $orderNum) {
        return self::getClass()->info([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $orderId) {
        return self::getClass()->close([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}