<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method closeOrderTimeByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表列表
     *
     * @param  string $dateStart 日期起 [ require true ]
     * @param  string $dateEnd 日期止 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $dateStart, string $dateEnd) {
        return self::getClass()->list([
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * 关闭时间点
     *
     * @param  string $status 位置的状态 [ require true ]
     * @param  string $orderTime 预约时间 [ require true ]
     * @param  int $index 预约位置索引(预约时间和索引必填一项) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderTime (string $status, string $orderTime, int $index) {
        return self::getClass()->closeOrderTime([
            "status" => $status,
            "orderTime" => $orderTime,
            "index" => $index,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}