<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createDsByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getDsByStoreByParams(array $params)
 */
class SubOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加二销
     *
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  float $money 二销金额 [Original type double] [ require true ]
     * @param  string $dsType ds类型 [ require true ]
     * @support  int $staffId 员工id [Original type uint] [ require true ]
     * @support  string $payType 支付类型 [ require true ]
     * @support  array $detail 子订单详情【子订单包含的产品&amp;服务】 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDs (int $orderId, string $dsType, float $money) {
        return self::getClass()->createDs([
            "orderId" => $orderId,
            "dsType" => $dsType,
            "money" => $money,
        ]);
    }

    /**
     * 删除二销订单
     *
     * @param  int $subId 二销ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $subId) {
        return self::getClass()->delete([
            "subId" => $subId,
        ]);
    }

    /**
     * 根据门店查询ds数据
     *
     * @param  int $dsModel 查询ds类型 1:共享 2主推 [ require true ]
     * @support  int $staffId 员工id [ require true ]
     * @support  string $startTime 查询开始时间 [ require true ]
     * @support  string $endTime 查询结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getDsByStore (int $dsModel) {
        return self::getClass()->getDsByStore([
            "dsModel" => $dsModel,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\SubOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\SubOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}