<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method grantStaffPermissionByParams(array $params)
 * @method getStaffPermissionsByParams(array $params)
 * @method getPermissionsByAppidByParams(array $params)
 */
class Permission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授予伙伴权限
     *
     * @param  array $permissionIds 权限数组 [Original type array&lt;int&gt;] [ require true ]
     * @param  int $staffId 伙伴id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function grantStaffPermission (array $permissionIds, int $staffId) {
        return self::getClass()->grantStaffPermission([
            "permissionIds" => $permissionIds,
            "staffId" => $staffId,
        ]);
    }

    /**
     * 获取伙伴权限
     *
     * @param  int $staffNum 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermissions (int $staffNum) {
        return self::getClass()->getStaffPermissions([
            "staffNum" => $staffNum,
        ]);
    }

    /**
     * 获取所有权限列表
     *
     * @param  int $appId 应用id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionsByAppid (int $appId) {
        return self::getClass()->getPermissionsByAppid([
            "appId" => $appId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Permission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Permission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}