<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryStaffWorkloadByParams(array $params)
 * @method queryDsByStoreByParams(array $params)
 */
class PerformanceManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询伙伴工作量 - 伙伴工作量导出
     *
     * @param  int $staff_type 岗位 [ require true ]
     * @support  int $staff_id 伙伴id [ require true ]
     * @support  string $start_time 开始时间 [ require true ]
     * @support  string $end_time 结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数据 
     * @param  bool $is_export 是否导出数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryStaffWorkload (bool $is_export, int $staff_type) {
        return self::getClass()->queryStaffWorkload([
            "is_export" => $is_export,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * 根据门店查询ds数据
     *
     * @param  int $ds_model 查询ds类型 1:共享 2主推 [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  string $start_time 查询开始时间 [ require true ]
     * @param  string $end_time 查询结束时间 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDsByStore (int $ds_model, int $staff_id, string $start_time, string $end_time, int $page = 1, int $page_size = 10) {
        return self::getClass()->queryDsByStore([
            "ds_model" => $ds_model,
            "staff_id" => $staff_id,
            "start_time" => $start_time,
            "end_time" => $end_time,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'PerformanceManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'PerformanceManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}