<?php
namespace Mainto\Bridge\Invokes\MantoProject\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByStoreByParams(array $params)
 * @method getStaffsByConditionByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getManagersByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据管理店铺获取员工信息
     *
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 获取记录条数 [Original type uint] [ require true ]
     * @param  bool $withDelete 是否在职 false:不包括 true：包括 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByStore (int $pageSize = 10, int $page = 1, bool $withDelete = true) {
        return self::getClass()->getStaffListByStore([
            "pageSize" => $pageSize,
            "page" => $page,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * 获取伙伴列表-分页
     *
     * @support  string $name 员工姓名 
     * @support  int $state 是否在职 
     * @support  int $staffNum 工号 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 获取记录条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffsByCondition (int $page, int $pageSize) {
        return self::getClass()->getStaffsByCondition([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取管理员列表
     *
     * @support  string $name 员工姓名 
     * @support  int $staffNum 员工工号 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getManagers (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getManagers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}