<?php
namespace Mainto\Bridge\Invokes\MantoProject\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method useUserIdGetUserInfoByParams(array $params)
 * @method changeUserInfoByParams(array $params)
 * @method changUserPasswordByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户的信息
     *
     * @param  string $loginType 登录类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useUserIdGetUserInfo (string $loginType = '') {
        return self::getClass()->useUserIdGetUserInfo([
            "loginType" => $loginType,
        ]);
    }

    /**
     * 修改用户预约资料
     *
     * @support  string $sex 用户性别 
     * @support  string $name 用户昵称 
     * @support  string $phone 手机号 
     * @support  string $birth 用户生日 
     * @support  string $email 用户邮箱 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserInfo () {
        return self::getClass()->changeUserInfo();
    }

    /**
     * 修改密码
     *
     * @param  string $oldPassword 用户老密码 [ require true ]
     * @param  string $newPassword 用户新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPassword (string $oldPassword, string $newPassword) {
        return self::getClass()->changUserPassword([
            "oldPassword" => $oldPassword,
            "newPassword" => $newPassword,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}