<?php
namespace Mainto\Bridge\Invokes\MantoProject\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method storePriceByParams(array $params)
 * @method bindStoreProductPriceByParams(array $params)
 * @method deleteStoreProductPriceByParams(array $params)
 * @method deleteAllStoreProductPriceByParams(array $params)
 * @method deleteProductPriceByParams(array $params)
 * @method deleteProductAllStoreAllPriceByParams(array $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品价格列表
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 设置产品价格
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  float $price 售卖价格 [Original type unsignedDouble] 
     * @support  float $originalPrice 原价 [Original type unsignedDouble] 
     * @support  float $addPeoplePrice 加人价格 [Original type unsignedDouble] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取某家门店的产品价格
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  array $productIds 限制查询的产品ID [Original type array&lt;uint&gt;] 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function storePrice () {
        return self::getClass()->storePrice();
    }

    /**
     * 该接口会做去重和删除之前绑定操作
     *
     * @support  int $priceId 价格ID [Original type uint] 
     * @support  array $storeIds 门店ID [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindStoreProductPrice () {
        return self::getClass()->bindStoreProductPrice();
    }

    /**
     * 删除门店价格
     *
     * @support  int $priceId 价格ID [Original type uint] 
     * @support  array $storeIds 门店ID [Original type array&lt;uint&gt;] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteStoreProductPrice () {
        return self::getClass()->deleteStoreProductPrice();
    }

    /**
     * 删除某个价格绑定的所有门店
     *
     * @support  int $priceId 价格ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteAllStoreProductPrice () {
        return self::getClass()->deleteAllStoreProductPrice();
    }

    /**
     * 删除一个价格
     *
     * @support  int $priceId 价格ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductPrice () {
        return self::getClass()->deleteProductPrice();
    }

    /**
     * 删除某个产品的价格绑定的所有门店
     *
     * @support  int $nodeId 价格ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductAllStoreAllPrice () {
        return self::getClass()->deleteProductAllStoreAllPrice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Product\ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Product\ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}