<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserPreferentialByParams(array $params)
 * @method redeemPreferentialByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户优惠券
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserPreferential () {
        return self::getClass()->getUserPreferential();
    }

    /**
     * 用户绑定优惠券
     *
     * @param  string $preferential_code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function redeemPreferential (string $preferential_code) {
        return self::getClass()->redeemPreferential([
            "preferential_code" => $preferential_code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}