<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreProductsByParams(array $params)
 * @method getStoreProductDetailByParams(array $params)
 * @method getStoreDiscountByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品
     *
     * @param  array $storeIds 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @param  bool $hiddenNoPrice 隐藏没有价格的节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProducts (array $storeIds, bool $includeHidden = false, bool $includeDelete = false, bool $hiddenNoPrice = true) {
        return self::getClass()->getStoreProducts([
            "storeIds" => $storeIds,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
            "hiddenNoPrice" => $hiddenNoPrice,
        ]);
    }

    /**
     * 获取门店产品详情
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @param  int $productId 门店ID [Original type uint] [ require true ]
     * @param  bool $includeHidden 包含隐藏节点 [ require true ]
     * @param  bool $includeDelete 包含下线节点 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreProductDetail (int $storeId, int $productId, bool $includeHidden = false, bool $includeDelete = false) {
        return self::getClass()->getStoreProductDetail([
            "storeId" => $storeId,
            "productId" => $productId,
            "includeHidden" => $includeHidden,
            "includeDelete" => $includeDelete,
        ]);
    }

    /**
     * 获取门店折扣规则
     *
     * @param  int $storeId 门店ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreDiscount (int $storeId) {
        return self::getClass()->getStoreDiscount([
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}