<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoresByParams(array $params)
 * @method getOrdersByParams(array $params)
 * @method inputLookerWorkloadByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云端获取所有门店接口
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStores () {
        return self::getClass()->getStores();
    }

    /**
     * 获取订单
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @support  string $phone 手机号 
     * @param  int $page 分页 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrders (string $order_num = '', string $name = '', int $page = 1) {
        return self::getClass()->getOrders([
            "order_num" => $order_num,
            "name" => $name,
            "page" => $page,
        ]);
    }

    /**
     * 看片师录单【单独的看片师录单接口】
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  int $staff_type 员工类型 [ require true ]
     * @param  float $work_per 工作量 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputLookerWorkload (string $order_num, int $staff_id, int $staff_type, float $work_per) {
        return self::getClass()->inputLookerWorkload([
            "order_num" => $order_num,
            "staff_id" => $staff_id,
            "staff_type" => $staff_type,
            "work_per" => $work_per,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}