<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method ReservedTimeByParams(array $params)
 * @method addOrderDataByParams(array $params)
 * @method getOrderDataByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method payByParams(array $params)
 * @method payCallbackByParams(array $params)
 */
class UserOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表时间
     *
     * @param  int $store_id 门店Id [ require true ]
     * @param  string $date_start 起止日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function ReservedTime (int $store_id, string $date_start, string $date_end) {
        return self::getClass()->ReservedTime([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
        ]);
    }

    /**
     * 创建订单[定金支付]
     * @deprecated
     *
     * @param  string $order_time 预约时间,2018-11-05 10:00:00 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  array $product_group 产品集合 [ require true ]
     * @param  float $money 实际支付金额 [Original type unsignedDouble] [ require true ]
     * @param  int $coupon_id 优惠券id [ require true ]
     * @param  string $pay_mode 支付模式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrderData (string $order_time, int $store_id, array $product_group, float $money, string $pay_mode, int $coupon_id = 0) {
        return self::getClass()->addOrderData([
            "order_time" => $order_time,
            "store_id" => $store_id,
            "product_group" => $product_group,
            "money" => $money,
            "pay_mode" => $pay_mode,
            "coupon_id" => $coupon_id,
        ]);
    }

    /**
     * 获取订单信息 [用户全部订单]
     *
     * @param  string $state 订单状态 [ require true ]
     * @param  int $page 分页 [ require true ]
     * @param  int $count 页数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderData (string $state, int $page = 1, int $count = 10) {
        return self::getClass()->getOrderData([
            "state" => $state,
            "page" => $page,
            "count" => $count,
        ]);
    }

    /**
     * 根据订单号获取订单
     *
     * @param  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail (string $order_num) {
        return self::getClass()->getOrderDetail([
            "order_num" => $order_num,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (int $orderId) {
        return self::getClass()->closeOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 发起支付
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @param  string $pay_mode 定金/全额 [ require true ]
     * @param  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  string $openId 用户openId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pay (int $order_id, string $pay_mode, string $pay_type, float $pay_money, int $store_id, string $openId = '') {
        return self::getClass()->pay([
            "order_id" => $order_id,
            "pay_mode" => $pay_mode,
            "pay_type" => $pay_type,
            "pay_money" => $pay_money,
            "store_id" => $store_id,
            "openId" => $openId,
        ]);
    }

    /**
     * 支付回调
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function payCallback () {
        return self::getClass()->payCallback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'UserOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'UserOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}