<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method useUserIdGetUserInfoByParams(array $params)
 * @method changeUserInfoByParams(array $params)
 * @method changUserPasswordByParams(array $params)
 * @method adviseFeedbackByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过用户id获取用户的信息
     *
     * @param  string $loginType 登录类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useUserIdGetUserInfo (string $loginType = '') {
        return self::getClass()->useUserIdGetUserInfo([
            "loginType" => $loginType,
        ]);
    }

    /**
     * 修改用户预约资料
     *
     * @support  string $phone 手机号 
     * @support  string $name 用户昵称 
     * @support  string $birth 用户生日 
     * @support  string $sex 用户性别 
     * @support  string $email 用户邮箱 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserInfo () {
        return self::getClass()->changeUserInfo();
    }

    /**
     * 修改密码
     *
     * @param  string $oldPassword 用户老密码 [ require true ]
     * @param  string $newPassword 用户新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPassword (string $oldPassword, string $newPassword) {
        return self::getClass()->changUserPassword([
            "oldPassword" => $oldPassword,
            "newPassword" => $newPassword,
        ]);
    }

    /**
     * 意见反馈
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  int $all_star 总评分 
     * @support  bool $is_share 是否参与分享 
     * @support  string $note 建议 
     * @support  int $photographer 摄影师打分 
     * @support  int $makeupArtist 化妆师打分 
     * @support  int $reception 前台打分 
     * @support  int $watchmaker 看片师打分 
     * @throws  \Exception
     * @return  mixed
     */
    public static function adviseFeedback () {
        return self::getClass()->adviseFeedback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}