<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reservedOrderByParams(array $params)
 * @method addOrderDataByParams(array $params)
 * @method getOrderDataByParams(array $params)
 * @method getOrderStatusByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method addDsInfoByParams(array $params)
 * @method leaveToPayByParams(array $params)
 * @method sendPaymentsByParams(array $params)
 * @method changeUserInfoByParams(array $params)
 * @method closeOrderTimeByParams(array $params)
 * @method startShootingByParams(array $params)
 * @method switchStoreByParams(array $params)
 * @method deleteDsInfoByParams(array $params)
 */
class ManageOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表
     *
     * @param  string $date_start 日期起 [ require true ]
     * @param  string $date_end 日期止 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reservedOrder (string $date_start, string $date_end) {
        return self::getClass()->reservedOrder([
            "date_start" => $date_start,
            "date_end" => $date_end,
        ]);
    }

    /**
     * 录入订单【用户、订单】
     *
     * @param  string $phone 手机号 [ require true ]
     * @support  string $email 邮箱 [ require true ]
     * @support  string $user_name 姓名 [ require true ]
     * @support  string $sex 性别 [ require true ]
     * @support  string $birthday 生日 [ require true ]
     * @param  array $product_group 产品id [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  string $note 备注 
     * @support  string $pay_mode 支付模式 [ require true ]
     * @param  float $money 付款金额 [Original type unsignedDouble] [ require true ]
     * @support  float $special_discount 折扣金额【缦图后台手动录入】 [Original type unsignedDouble] 
     * @support  string $discount_note 特殊折扣备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addOrderData (string $phone, array $product_group, float $money) {
        return self::getClass()->addOrderData([
            "phone" => $phone,
            "product_group" => $product_group,
            "money" => $money,
        ]);
    }

    /**
     * 订单搜索和查找接口（带分页)
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $user_name 姓名 [ require true ]
     * @param  array $state 订单状态 [ require true ]
     * @param  int $page 分页 [ require true ]
     * @param  int $page_size 页数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderData (string $phone = '', string $order_num = '', string $user_name = '', array $state = [], int $page = 1, int $page_size = 10) {
        return self::getClass()->getOrderData([
            "phone" => $phone,
            "order_num" => $order_num,
            "user_name" => $user_name,
            "state" => $state,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取订单状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderStatus () {
        return self::getClass()->getOrderStatus();
    }

    /**
     * 订单详情 - 打印订单
     *
     * @param  int $order_id 订单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail (int $order_id) {
        return self::getClass()->getOrderDetail([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id 订单Id [ require true ]
     * @param  string $close_note 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (int $id, string $close_note = '') {
        return self::getClass()->closeOrder([
            "id" => $id,
            "close_note" => $close_note,
        ]);
    }

    /**
     * 录入DS
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $type ds类型 [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  float $price ds金额 [Original type double] [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  array $products 产品 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addDsInfo (int $order_id, int $staff_id, string $type, string $pay_type, array $products, float $price) {
        return self::getClass()->addDsInfo([
            "order_id" => $order_id,
            "staff_id" => $staff_id,
            "type" => $type,
            "pay_type" => $pay_type,
            "products" => $products,
            "price" => $price,
        ]);
    }

    /**
     * 尾款录入
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function leaveToPay (int $order_id, string $pay_type, float $pay_money) {
        return self::getClass()->leaveToPay([
            "order_id" => $order_id,
            "pay_type" => $pay_type,
            "pay_money" => $pay_money,
        ]);
    }

    /**
     * 支付
     *
     * @param  string $order_num 订单号 [ require true ]
     * @param  string $pay_mode 定金/全额 [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendPayments (string $order_num, string $pay_mode, float $pay_money, string $pay_type) {
        return self::getClass()->sendPayments([
            "order_num" => $order_num,
            "pay_mode" => $pay_mode,
            "pay_money" => $pay_money,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 修改用户信息 | 预约信息
     *
     * @param  int $id 订单Id [ require true ]
     * @support  string $phone 手机号 
     * @support  string $user_name 姓名 
     * @support  string $sex 性别 
     * @support  string $birthday 生日 
     * @support  string $email 邮箱 
     * @support  string $order_time 预约时间 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserInfo (int $id) {
        return self::getClass()->changeUserInfo([
            "id" => $id,
        ]);
    }

    /**
     * 关闭时间点-释放时间点
     *
     * @param  string $state 位置的状态 [ require true ]
     * @param  string $order_time 预约时间 [ require true ]
     * @param  int $index 预约位置索引(预约时间和索引必填一项) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrderTime (string $state, string $order_time, int $index) {
        return self::getClass()->closeOrderTime([
            "state" => $state,
            "order_time" => $order_time,
            "index" => $index,
        ]);
    }

    /**
     * 开始拍摄
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function startShooting (int $order_id) {
        return self::getClass()->startShooting([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 切换门店
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function switchStore (int $store_id) {
        return self::getClass()->switchStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 删除二销订单
     *
     * @param  int $ds_id 二销ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDsInfo (int $ds_id) {
        return self::getClass()->deleteDsInfo([
            "ds_id" => $ds_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'ManageOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'ManageOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}