<?php
namespace Mainto\Bridge\Invokes\MantoProject;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method inputWorkloadByParams(array $params)
 * @method getStaffWorkloadByParams(array $params)
 * @method getStaffListByStoreByParams(array $params)
 * @method getStaffPermissionByParams(array $params)
 * @method grantStaffPermissionByParams(array $params)
 * @method getStaffListByConditionByParams(array $params)
 * @method getManagerInfoByParams(array $params)
 * @method getManagersListByParams(array $params)
 * @method getPermissionsByAppidByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 录入员工工作量
     *
     * @param  int $order_id 订单号 [ require true ]
     * @param  array $work_data 录入的工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inputWorkload (int $order_id, array $work_data) {
        return self::getClass()->inputWorkload([
            "order_id" => $order_id,
            "work_data" => $work_data,
        ]);
    }

    /**
     * 获取工作量
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffWorkload (int $order_id) {
        return self::getClass()->getStaffWorkload([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取门店伙伴列表
     *
     * @support  int $count 获取记录条数 
     * @support  int $page 页数 
     * @support  bool $withDelete 是否在职 false:不包括 true：包括 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByStore () {
        return self::getClass()->getStaffListByStore();
    }

    /**
     * 获取伙伴权限
     *
     * @param  int $staff_num 伙伴工号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermission (int $staff_num) {
        return self::getClass()->getStaffPermission([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 授予伙伴权限
     *
     * @param  array $permission_ids 权限数组 [Original type array&lt;int&gt;] [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function grantStaffPermission (array $permission_ids, int $staff_id) {
        return self::getClass()->grantStaffPermission([
            "permission_ids" => $permission_ids,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 伙伴管理
     *
     * @param  string $name 员工姓名 [ require true ]
     * @support  int $staff_num 工号 
     * @support  int $state 是否在职 
     * @support  int $count 获取记录条数 [Original type uint] 
     * @support  int $page 页数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByCondition (string $name = '') {
        return self::getClass()->getStaffListByCondition([
            "name" => $name,
        ]);
    }

    /**
     * 获取管理员信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getManagerInfo () {
        return self::getClass()->getManagerInfo();
    }

    /**
     * 获取管理员列表【缦图门店】
     *
     * @param  string $name 员工姓名 [ require true ]
     * @param  int $staff_num 员工工号 [ require true ]
     * @support  int $page 员工工号 
     * @support  int $page_size 员工工号 
     * @throws  \Exception
     * @return  array
     */
    public static function getManagersList (int $staff_num = NULL, string $name = '') {
        return self::getClass()->getManagersList([
            "staff_num" => $staff_num,
            "name" => $name,
        ]);
    }

    /**
     * 获取所有权限列表
     *
     * @param  int $appid 应用id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionsByAppid (int $appid) {
        return self::getClass()->getPermissionsByAppid([
            "appid" => $appid,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('MantoProject', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('MantoProject', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}