<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-18 15:57:39
 */
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ThirdPartyStaffRole
 * @method grantRoleByParams(array $params) 授予第三方账户角色
 * @method batchGrantRolesByParams(array $params) 批量授予第三方账户角色集合
 * @method batchUnbindRolesByParams(array $params) 批量解绑第三方账户角色集合
 * @method getStaffPermissionsByParams(array $params) 获取第三方员工对应的权限点
 * @method unbindRoleByParams(array $params) 解绑第三方账户角色
 */
class ThirdPartyStaffRole {
    private static string $serviceName = "ManageAuth";

    private static string $className = "ThirdPartyStaffRole";

    /**
     * 授予第三方账户角色
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function grantRole (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole($_params);
    }

    /**
     * 批量授予第三方账户角色集合
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function batchGrantRoles (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGrantRoles($_params);
    }

    /**
     * 批量解绑第三方账户角色集合
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function batchUnbindRoles (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUnbindRoles($_params);
    }

    /**
     * 获取第三方员工对应的权限点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffPermissions (int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermissions(["staffId" => $staffId]);
    }

    /**
     * 解绑第三方账户角色
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function unbindRole (int $roleId, int $staffId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindRole(["roleId" => $roleId, "staffId" => $staffId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}