<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-18 15:57:39
 */
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Staff
 * @method checkStaffPermissionByParams(array $params) 检测伙伴是否有指定权限点
 * @method getStaffRoleListByParams(array $params) 获取伙伴已授权角色
 * @method getStaffRoleListByPageByParams(array $params) 获取伙伴已授权角色
 * @method getRelationIdByParams(array $params) getRelationId
 * @method getStaffPermissionListByParams(array $params) 获取伙伴已授权权限
 * @method getStaffPermissionListByPageByParams(array $params) 获取伙伴已授权权限
 * @method grantRoleByParams(array $params) grantRole
 * @method grantPermissionByParams(array $params) grantPermission
 * @method grantBatchPermissionByParams(array $params) grantBatchPermission
 * @method revokeRoleByParams(array $params) revokeRole
 * @method revokePermissionByParams(array $params) revokePermission
 * @method getAdminByStoreByParams(array $params) getAdminByStore
 * @method getAdminIdByStoreByParams(array $params) getAdminIdByStore
 * @method getAdminIdByStoreIdsByParams(array $params) getAdminIdByStoreIds
 * @method getAdminByAppIdByParams(array $params) getAdminByAppId
 * @method deleteStaffAppPermissionByParams(array $params) 删除伙伴应用数据及相关应用的权限
 * @method handleStaffAppDataByParams(array $params) handleStaffAppData
 * @method getStaffByPermissionByParams(array $params) 根据权限id获取对应伙伴
 * @method getStaffsByRoleByParams(array $params) 根据角色获取对应的伙伴
 * @method getStaffRoleListsByParams(array $params) 批量获取伙伴已授权角色
 * @method getStaffIdsContainPermissionsByParams(array $params) 获取拥有指定权限伙伴IDs
 */
class Staff {
    private static string $serviceName = "ManageAuth";

    private static string $className = "Staff";

    /**
     * 检测伙伴是否有指定权限点
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkStaffPermission (int $staffId, string $permissionName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffPermission(["staffId" => $staffId, "permissionName" => $permissionName]);
    }

    /**
     * 获取伙伴已授权角色
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffRoleList (int $staffId, int $appId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleList(["staffId" => $staffId, "appId" => $appId]);
    }

    /**
     * 获取伙伴已授权角色
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffRoleListByPage (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleListByPage(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * getRelationId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getRelationId (int $staffId, int $keyId, int $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRelationId(["staffId" => $staffId, "keyId" => $keyId, "type" => $type]);
    }

    /**
     * 获取伙伴已授权权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffPermissionList (int $staff_id, bool $isRole = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermissionList(["staff_id" => $staff_id, "isRole" => $isRole]);
    }

    /**
     * 获取伙伴已授权权限
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getStaffPermissionListByPage (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermissionListByPage(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * grantRole
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function grantRole (int $roleId, int $staffId, int $effectAt = 0, int $expireAt = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole(["roleId" => $roleId, "staffId" => $staffId, "effectAt" => $effectAt, "expireAt" => $expireAt]);
    }

    /**
     * grantPermission
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function grantPermission (int $permissionId, int $staffId, int $effectAt = 0, int $expireAt = 0, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantPermission(array_merge($_params, ["permissionId" => $permissionId, "staffId" => $staffId, "effectAt" => $effectAt, "expireAt" => $expireAt]));
    }

    /**
     * grantBatchPermission
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function grantBatchPermission (int $staff_id, array $addPermissionIds = [], array $delPermissionIds = [], int $effectAt = 0, int $expireAt = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantBatchPermission(["staff_id" => $staff_id, "addPermissionIds" => $addPermissionIds, "delPermissionIds" => $delPermissionIds, "effectAt" => $effectAt, "expireAt" => $expireAt]);
    }

    /**
     * revokeRole
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function revokeRole (int $relationId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeRole(array_merge($_params, ["relationId" => $relationId]));
    }

    /**
     * revokePermission
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function revokePermission (int $relationId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokePermission(array_merge($_params, ["relationId" => $relationId]));
    }

    /**
     * getAdminByStore
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdminByStore (int $store_id, array $staff_ids = [], int $page = 1, int $page_size = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminByStore(["store_id" => $store_id, "staff_ids" => $staff_ids, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * getAdminIdByStore
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdminIdByStore (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminIdByStore(["store_id" => $store_id]);
    }

    /**
     * getAdminIdByStoreIds
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdminIdByStoreIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminIdByStoreIds(["storeIds" => $storeIds]);
    }

    /**
     * getAdminByAppId
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAdminByAppId (int $app_id = 0, array $staff_ids = [], int $status = 0, int $page = 1, int $page_size = 15) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminByAppId(["app_id" => $app_id, "staff_ids" => $staff_ids, "status" => $status, "page" => $page, "page_size" => $page_size]);
    }

    /**
     * 删除伙伴应用数据及相关应用的权限
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteStaffAppPermission (int $staffId, int $appId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStaffAppPermission(["staffId" => $staffId, "appId" => $appId]);
    }

    /**
     * handleStaffAppData
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function handleStaffAppData (int $staffId, int $appId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleStaffAppData(["staffId" => $staffId, "appId" => $appId, "status" => $status]);
    }

    /**
     * 根据权限id获取对应伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffByPermission (int $permissionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByPermission(["permissionId" => $permissionId]);
    }

    /**
     * 根据角色获取对应的伙伴
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffsByRole (int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffsByRole(["roleId" => $roleId]);
    }

    /**
     * 批量获取伙伴已授权角色
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getStaffRoleLists (array $staffIds, int $appId = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleLists(["staffIds" => $staffIds, "appId" => $appId]);
    }

    /**
     * 获取拥有指定权限伙伴IDs
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStaffIdsContainPermissions (array $staffIds, string $containPermissionName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsContainPermissions(["staffIds" => $staffIds, "containPermissionName" => $containPermissionName]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}