<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-09-18 15:57:39
 */
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Auth
 * @method getStaffInfoByTokenByParams(array $params) 通过SSO令牌获取基本信息
 * @method getLoginInfoByParams(array $params) 获取登陆用户信息
 * @method loginByTokenByParams(array $params) 通过SSO令牌登录
 * @method loginByAdminCodeByParams(array $params) 通过手动指定工号进行登录
 * @method loginByCodeByParams(array $params) 通过Code进行员工登录
 * @method loginByDingDingByParams(array $params) 获取钉钉用户信息
 * @method logoutByParams(array $params) 退出登录
 * @method getAuthExpireTimeByParams(array $params) 获取当前session过期时间
 * @method cloud3rdLoginByParams(array $params) 云图外包修片/摄影账号登录
 * @method registerAffiliateAccountByParams(array $params) 注册加盟商账户
 * @method loginAffiliateByParams(array $params) 加盟商登录
 * @method loginByOnlineTokenByParams(array $params) 根据线上token登陆
 * @method geetestRegisterByParams(array $params) 极验初始化信息
 * @method geeTestValidateByParams(array $params) 二次验证
 * @method loginByPhoneByParams(array $params) 校验登录, 返回登录ID
 * @method loginByNewTokenByParams(array $params) 从java端给的token注入用户信息, 返回登录ID
 */
class Auth {
    private static string $serviceName = "ManageAuth";

    private static string $className = "Auth";

    /**
     * 通过SSO令牌获取基本信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getStaffInfoByToken (string $token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoByToken(array_merge($_params, ["token" => $token]));
    }

    /**
     * 获取登陆用户信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getLoginInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginInfo();
    }

    /**
     * 通过SSO令牌登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByToken (string $token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByToken(array_merge($_params, ["token" => $token]));
    }

    /**
     * 通过手动指定工号进行登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByAdminCode (string $authCode, string $staffId, array $permissions = [], array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByAdminCode(array_merge($_params, ["authCode" => $authCode, "staffId" => $staffId, "permissions" => $permissions]));
    }

    /**
     * 通过Code进行员工登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByCode (string $from, string $code, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByCode(array_merge($_params, ["from" => $from, "code" => $code]));
    }

    /**
     * 获取钉钉用户信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByDingDing (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByDingDing($_params);
    }

    /**
     * 退出登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function logout () {
        return RpcClass::getClass(self::$serviceName, self::$className)->logout();
    }

    /**
     * 获取当前session过期时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAuthExpireTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthExpireTime();
    }

    /**
     * 云图外包修片/摄影账号登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function cloud3rdLogin (string $username, string $password, string $ticket = '', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloud3rdLogin(array_merge($_params, ["username" => $username, "password" => $password, "ticket" => $ticket]));
    }

    /**
     * 注册加盟商账户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function registerAffiliateAccount (string $account, string $password, string $name, array $store_ids = [], array $role_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->registerAffiliateAccount(["account" => $account, "password" => $password, "name" => $name, "store_ids" => $store_ids, "role_ids" => $role_ids]);
    }

    /**
     * 加盟商登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginAffiliate (string $account, string $password, string $ticket, string $randStr, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginAffiliate(array_merge($_params, ["account" => $account, "password" => $password, "ticket" => $ticket, "randStr" => $randStr]));
    }

    /**
     * 根据线上token登陆
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByOnlineToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByOnlineToken();
    }

    /**
     * 极验初始化信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function geetestRegister (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->geetestRegister($_params);
    }

    /**
     * 二次验证
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function geeTestValidate (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->geeTestValidate($_params);
    }

    /**
     * 校验登录, 返回登录ID
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByPhone (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPhone($_params);
    }

    /**
     * 从java端给的token注入用户信息, 返回登录ID
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByNewToken (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByNewToken($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}