<?php
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method grantRoleByParams(array $params)
 * @method getStaffPermissionsByParams(array $params)
 * @method unbindRoleByParams(array $params)
 */
class ThirdPartyStaffRole {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授予第三方账户角色
     *
     * @support  int $roleId 角色ID [ require true ]
     * @support  int $staffId 员工ID [ require true ]
     * @support  string $effectAt 起效时间(不传递-立即生效) [ require false ]
     * @support  string $expireAt 过期时间(不传递-永不过期) [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function grantRole () {
        return self::getClass()->grantRole([
        ]);
    }

    /**
     * 获取第三方员工对应的权限点
     *
     * @param  int $staffId 员工ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ManageAuth\ThirdPartyStaffPermissionsDTO[]
     */
    public static function getStaffPermissions (int $staffId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStaffPermissions([
                            "staffId" => $staffId,
                        ]),
            "\Mainto\Bridge\Structs\ManageAuth\ThirdPartyStaffPermissionsDTO[]"
        );
    }

    /**
     * 解绑第三方账户角色
     *
     * @param  int $roleId 角色ID [ require true ]
     * @param  int $staffId 员工ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unbindRole (int $roleId, int $staffId) {
        return self::getClass()->unbindRole([
            "roleId" => $roleId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ManageAuth', 'ThirdPartyStaffRole');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ManageAuth', 'ThirdPartyStaffRole');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}