<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-07 11:20:06
 */
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Auth
 */
class Auth {
    private static string $serviceName = "ManageAuth";

    private static string $className = "Auth";

    /**
     * 通过SSO令牌获取基本信息
     */
    public static function getStaffInfoByToken (string $token): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffInfoByToken(["token" => $token, ]);
    }
    /**
     * 获取登陆用户信息
     */
    public static function getLoginInfo (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginInfo();
    }
    /**
     * 通过SSO令牌登录
     */
    public static function loginByToken (string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByToken(["token" => $token, ]);
    }
    /**
     * 通过手动指定工号进行登录
     */
    public static function loginByAdminCode (string $authCode, string $staffId, array $permissions = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByAdminCode(["authCode" => $authCode, "staffId" => $staffId, "permissions" => $permissions, ]);
    }
    /**
     * 通过Code进行员工登录
     */
    public static function loginByCode (string $from, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByCode(["from" => $from, "code" => $code, ]);
    }
    /**
     * 获取钉钉用户信息
     */
    public static function loginByDingDing (string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByDingDing(["code" => $code, ]);
    }
    /**
     * 退出登录
     */
    public static function logout () {
        return RpcClass::getClass(self::$serviceName, self::$className)->logout();
    }
    /**
     * 云图外包修片/摄影账号登录
     */
    public static function cloud3rdLogin (string $username, string $password, string $ticket = '', string $captchaId, string $randStr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cloud3rdLogin(["username" => $username, "password" => $password, "ticket" => $ticket, "captchaId" => $captchaId, "randStr" => $randStr, ]);
    }
    /**
     * 注册加盟商账户
     */
    public static function registerAffiliateAccount (string $account, string $password, string $name, array $store_ids = [], array $role_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->registerAffiliateAccount(["account" => $account, "password" => $password, "name" => $name, "store_ids" => $store_ids, "role_ids" => $role_ids, ]);
    }
    /**
     * 加盟商登录
     */
    public static function loginAffiliate (string $account, string $password, string $ticket, string $randStr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginAffiliate(["account" => $account, "password" => $password, "ticket" => $ticket, "randStr" => $randStr, ]);
    }
    /**
     * 根据线上token登陆
     */
    public static function loginByOnlineToken () {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByOnlineToken();
    }
    /**
     * 极验初始化信息
     */
    public static function geetestRegister (string $clientType, string $ip) {
        return RpcClass::getClass(self::$serviceName, self::$className)->geetestRegister(["clientType" => $clientType, "ip" => $ip, ]);
    }
    /**
     * 二次验证
     */
    public static function geeTestValidate (string $geeTestChallenge, string $geeTestValidate, string $geeTestSecCode, string $phone) {
        return RpcClass::getClass(self::$serviceName, self::$className)->geeTestValidate(["geeTestChallenge" => $geeTestChallenge, "geeTestValidate" => $geeTestValidate, "geeTestSecCode" => $geeTestSecCode, "phone" => $phone, ]);
    }
    /**
     * 校验登录, 返回登录ID
     */
    public static function loginByPhone (string $code, string $phone, string $password) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPhone(["code" => $code, "phone" => $phone, "password" => $password, ]);
    }
    /**
     * 从java端给的token注入用户信息, 返回登录ID
     */
    public static function loginByNewToken (string $token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByNewToken(["token" => $token, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}