<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-03 09:41:45
 */
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Staff
 */
class Staff {
    private static string $serviceName = "ManageAuth";

    private static string $className = "Staff";

    /**
     * 检测伙伴是否有指定权限点
     *
     */
    public static function checkStaffPermission (int $staffId, string $permissionName): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkStaffPermission(["staffId" => $staffId, "permissionName" => $permissionName, ]);
    }
    /**
     * 获取伙伴已授权角色
     *
     */
    public static function getStaffRoleList (int $staffId, int $appId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleList(["staffId" => $staffId, "appId" => $appId, ]);
    }
    /**
     * 获取伙伴已授权角色
     *
     */
    public static function getStaffRoleListByPage (int $staffId, array $staffIds, bool $withRoleInfo, bool $withRoleContainPermission, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleListByPage(["staffId" => $staffId, "staffIds" => $staffIds, "withRoleInfo" => $withRoleInfo, "withRoleContainPermission" => $withRoleContainPermission, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * getRelationId
     *
     */
    public static function getRelationId (int $staffId, int $keyId, int $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRelationId(["staffId" => $staffId, "keyId" => $keyId, "type" => $type, ]);
    }
    /**
     * 获取伙伴已授权权限
     *
     */
    public static function getStaffPermissionList (int $staff_id, bool $isRole) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermissionList(["staff_id" => $staff_id, "isRole" => $isRole, ]);
    }
    /**
     * 获取伙伴已授权权限
     *
     */
    public static function getStaffPermissionListByPage (int $staffId, array $staffIds, bool $withPermission, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffPermissionListByPage(["staffId" => $staffId, "staffIds" => $staffIds, "withPermission" => $withPermission, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * grantRole
     *
     */
    public static function grantRole (int $roleId, int $staffId, int $effectAt, int $expireAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantRole(["roleId" => $roleId, "staffId" => $staffId, "effectAt" => $effectAt, "expireAt" => $expireAt, ]);
    }
    /**
     * grantPermission
     *
     */
    public static function grantPermission (int $permissionId, int $staffId, int $effectAt, int $expireAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantPermission(["permissionId" => $permissionId, "staffId" => $staffId, "effectAt" => $effectAt, "expireAt" => $expireAt, ]);
    }
    /**
     * grantBatchPermission
     *
     */
    public static function grantBatchPermission (array $addPermissionIds, array $delPermissionIds, int $staff_id, int $effectAt, int $expireAt) {
        return RpcClass::getClass(self::$serviceName, self::$className)->grantBatchPermission(["addPermissionIds" => $addPermissionIds, "delPermissionIds" => $delPermissionIds, "staff_id" => $staff_id, "effectAt" => $effectAt, "expireAt" => $expireAt, ]);
    }
    /**
     * revokeRole
     *
     */
    public static function revokeRole (int $relationId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokeRole(["relationId" => $relationId, ]);
    }
    /**
     * revokePermission
     *
     */
    public static function revokePermission (int $relationId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->revokePermission(["relationId" => $relationId, ]);
    }
    /**
     * getAdminByStore
     *
     */
    public static function getAdminByStore (int $store_id, array $staff_ids, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminByStore(["store_id" => $store_id, "staff_ids" => $staff_ids, "page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * getAdminIdByStore
     *
     */
    public static function getAdminIdByStore (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminIdByStore(["store_id" => $store_id, ]);
    }
    /**
     * getAdminIdByStoreIds
     *
     */
    public static function getAdminIdByStoreIds (array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminIdByStoreIds(["storeIds" => $storeIds, ]);
    }
    /**
     * getAdminByAppId
     *
     */
    public static function getAdminByAppId (int $app_id, array $staff_ids, int $page, int $page_size, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAdminByAppId(["app_id" => $app_id, "staff_ids" => $staff_ids, "page" => $page, "page_size" => $page_size, "status" => $status, ]);
    }
    /**
     * 删除伙伴应用数据及相关应用的权限
     *
     */
    public static function deleteStaffAppPermission (int $staffId, int $appId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStaffAppPermission(["staffId" => $staffId, "appId" => $appId, ]);
    }
    /**
     * handleStaffAppData
     *
     */
    public static function handleStaffAppData (int $staffId, int $appId, int $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->handleStaffAppData(["staffId" => $staffId, "appId" => $appId, "status" => $status, ]);
    }
    /**
     * 根据权限id获取对应伙伴
     *
     */
    public static function getStaffByPermission (int $permissionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffByPermission(["permissionId" => $permissionId, ]);
    }
    /**
     * 根据角色获取对应的伙伴
     *
     */
    public static function getStaffsByRole (int $roleId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffsByRole(["roleId" => $roleId, ]);
    }
    /**
     * 批量获取伙伴已授权角色
     *
     */
    public static function getStaffRoleLists (array $staffIds, int $appId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffRoleLists(["staffIds" => $staffIds, "appId" => $appId, ]);
    }
    /**
     * 获取拥有指定权限伙伴IDs
     *
     */
    public static function getStaffIdsContainPermissions (array $staffIds, string $containPermissionName): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStaffIdsContainPermissions(["staffIds" => $staffIds, "containPermissionName" => $containPermissionName, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}