<?php
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRoleListByParams(array $params)
 * @method getOneRoleByParams(array $params)
 * @method editRoleByParams(array $params)
 * @method createRoleByParams(array $params)
 * @method syncPermissionByParams(array $params)
 * @method deleteRoleByParams(array $params)
 */
class Role {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过应用ID获取角色列表
     *
     * @param  int $appid 应用ID [ require false ]
     * @param  string $title 角色名称 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRoleList (int $appid = 0, string $title = '', int $page = 1, int $page_size = 15) {
        return self::getClass()->getRoleList([
            "appid" => $appid,
            "title" => $title,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取单个角色信息
     *
     * @param  int $roleId 角色ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOneRole (int $roleId) {
        return self::getClass()->getOneRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * 修改角色信息
     *
     * @param  int $roleId 角色ID [ require true ]
     * @param  string $title 标题 [ require false ]
     * @param  int $application 应用 [ require false ]
     * @param  string $desc 备注 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRole (int $roleId, string $title = '', int $application = 0, string $desc = '') {
        return self::getClass()->editRole([
            "roleId" => $roleId,
            "title" => $title,
            "application" => $application,
            "desc" => $desc,
        ]);
    }

    /**
     * 创建角色
     *
     * @param  int $appid 应用ID [ require true ]
     * @param  string $title 角色名 [ require true ]
     * @param  string $desc 角色描述 [ require false ]
     * @param  int $founderId 创建人id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createRole (int $appid, string $title, string $desc = '', int $founderId = 0) {
        return self::getClass()->createRole([
            "appid" => $appid,
            "title" => $title,
            "desc" => $desc,
            "founderId" => $founderId,
        ]);
    }

    /**
     * 同步角色权限
     *
     * @param  int $roleId 角色ID [ require true ]
     * @param  string $permissions 最终选定的权限ID集合(以&#039;-&#039;连接权限ID) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncPermission (int $roleId, string $permissions) {
        return self::getClass()->syncPermission([
            "roleId" => $roleId,
            "permissions" => $permissions,
        ]);
    }

    /**
     * 删除角色
     *
     * @param  int $roleId 角色ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteRole (int $roleId) {
        return self::getClass()->deleteRole([
            "roleId" => $roleId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ManageAuth', 'Role');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ManageAuth', 'Role');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}