<?php
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffInfoByTokenByParams(array $params)
 * @method getLoginInfoByParams(array $params)
 * @method loginByTokenByParams(array $params)
 * @method loginByAdminCodeByParams(array $params)
 * @method loginByCodeByParams(array $params)
 * @method loginByDingDingByParams(array $params)
 * @method logoutByParams(array $params)
 * @method cloud3rdLoginByParams(array $params)
 * @method registerAffiliateAccountByParams(array $params)
 * @method loginAffiliateByParams(array $params)
 * @method loginByOnlineTokenByParams(array $params)
 * @method geetestRegisterByParams(array $params)
 * @method geeTestValidateByParams(array $params)
 * @method loginByPhoneByParams(array $params)
 * @method loginByNewTokenByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过SSO令牌获取基本信息
     *
     * @param  string $token SSO令牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffInfoByToken (string $token) {
        return self::getClass()->getStaffInfoByToken([
            "token" => $token,
        ]);
    }

    /**
     * getLoginInfo
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getLoginInfo () {
        return self::getClass()->getLoginInfo();
    }

    /**
     * 通过SSO令牌登录
     *
     * @param  string $token SSO令牌 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByToken (string $token) {
        return self::getClass()->loginByToken([
            "token" => $token,
        ]);
    }

    /**
     * 通过手动指定工号进行登录
     *
     * @param  string $authCode 授权代码 [ require true ]
     * @param  string $staffId 员工ID [ require true ]
     * @param  array $permissions 需要附加的权限 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByAdminCode (string $authCode, string $staffId, array $permissions = []) {
        return self::getClass()->loginByAdminCode([
            "authCode" => $authCode,
            "staffId" => $staffId,
            "permissions" => $permissions,
        ]);
    }

    /**
     * 通过Code进行员工登录
     *
     * @param  string $from Code来源 [ require true ]
     * @param  string $code Code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByCode (string $from, string $code) {
        return self::getClass()->loginByCode([
            "from" => $from,
            "code" => $code,
        ]);
    }

    /**
     * 获取钉钉用户信息
     *
     * @support  string $code 授权code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByDingDing () {
        return self::getClass()->loginByDingDing([
        ]);
    }

    /**
     * 退出登录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function logout () {
        return self::getClass()->logout();
    }

    /**
     * cloud3rdLogin
     *
     * @param  string $username 用户名 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @support  string $captchaId 无痕验证应用ID [ require false ]
     * @param  string $ticket ticket [ require true ]
     * @support  string $randStr randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cloud3rdLogin (string $username, string $password, string $ticket = '') {
        return self::getClass()->cloud3rdLogin([
            "username" => $username,
            "password" => $password,
            "ticket" => $ticket,
        ]);
    }

    /**
     * 注册加盟商账户
     *
     * @param  string $account 账户 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @param  string $name 姓名 [ require true ]
     * @param  array $store_ids 门店ids [ require false ]
     * @param  array $role_ids 角色ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function registerAffiliateAccount (string $account, string $password, string $name, array $store_ids = [], array $role_ids = []) {
        return self::getClass()->registerAffiliateAccount([
            "account" => $account,
            "password" => $password,
            "name" => $name,
            "store_ids" => $store_ids,
            "role_ids" => $role_ids,
        ]);
    }

    /**
     * 加盟商登录
     *
     * @param  string $account 账户 [ require true ]
     * @param  string $password 密码 [ require true ]
     * @support  string $ticket 前端回调ticket [ require true ]
     * @support  string $randStr 前端回调randstr [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginAffiliate (string $account, string $password) {
        return self::getClass()->loginAffiliate([
            "account" => $account,
            "password" => $password,
        ]);
    }

    /**
     * loginByOnlineToken
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByOnlineToken () {
        return self::getClass()->loginByOnlineToken();
    }

    /**
     * 极验初始化信息
     *
     * @support  string $clientType 客户端类型 [ require true ]
     * @support  string $ip 客户端ip [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function geetestRegister () {
        return self::getClass()->geetestRegister([
        ]);
    }

    /**
     * 二次验证
     *
     * @support  string $geeTestChallenge 流水号，一次完整验证流程的唯一标识 [ require true ]
     * @support  string $geeTestValidate validate [ require false ]
     * @support  string $geeTestSecCode 核心校验数据 [ require false ]
     * @support  string $phone 用户手机号 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function geeTestValidate () {
        return self::getClass()->geeTestValidate([
        ]);
    }

    /**
     * 校验登录, 返回登录ID
     *
     * @support  string $code 验证码 [ require false ]
     * @support  string $phone 用户手机号 [ require false ]
     * @support  string $password 密码 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPhone () {
        return self::getClass()->loginByPhone([
        ]);
    }

    /**
     * 从java端给的token注入用户信息, 返回登录ID
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByNewToken () {
        return self::getClass()->loginByNewToken();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ManageAuth', 'Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ManageAuth', 'Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}