<?php
namespace Mainto\Bridge\Invokes\ManageAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method grantAuthToStaffByParams(array $params)
 * @method getAuthByStaffByParams(array $params)
 * @method getAuthByStaffsByParams(array $params)
 */
class StoreAuth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 授权伙伴门店权限
     *
     * @param  int $staffId 伙伴id [ require true ]
     * @param  array $newStoreIds 新增权限 [ require true ]
     * @param  array $removeStoreIds 删除权限 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function grantAuthToStaff (int $staffId, array $newStoreIds = [], array $removeStoreIds = []) {
        return self::getClass()->grantAuthToStaff([
            "staffId" => $staffId,
            "newStoreIds" => $newStoreIds,
            "removeStoreIds" => $removeStoreIds,
        ]);
    }

    /**
     * 根据伙伴id获取权限列表
     *
     * @param  int $staffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAuthByStaff (int $staffId) {
        return self::getClass()->getAuthByStaff([
            "staffId" => $staffId,
        ]);
    }

    /**
     * 根据伙伴ids获取相关门店权限列表
     *
     * @param  array $staffIds 伙伴IDs [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthByStaffs (array $staffIds) {
        return self::getClass()->getAuthByStaffs([
            "staffIds" => $staffIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ManageAuth', 'StoreAuth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ManageAuth', 'StoreAuth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}